*********************************************************************
*****************DEBT AND CONSUMPTION - MAIN MODELS******************
*************************DATE: MAY 2019 *****************************
********************* AUTHOR: FIONA PRICE ***************************
*********************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace
sort hhid0 wave

replace hdebtt = . if hdebtt!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property
replace mortinc = . if mortinc!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property
replace debtasset = . if debtasset!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property
replace hdebtinc = . if hdebtinc!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property


*************
***TABLE 1***
*************
mat Table1 = J(7,9,.)
mat rown Table1 = Debtcoeff Debtpv Inccoeff Incpv Hpcoeff Hppv Obs
mat coln Table1 = NondurableOLS NondurableOLSFE NondurableIV DurableOLS DurableOLSFE DurableIV TotalOLS TotalOLSFE TotalIV

//set up debt measure for model (hdebtt, hdebtinc, debtasset, mortinc - use first for Table 1 in RDP and last three for tables in Appendix E in RDP)
local debtvar debtasset

//set up assets measure for model (hp1t hequityt - use first for Table 1 in RDP, second for Table 2 in RDP)
local assetvar hp1t

//set up list of control variables for model hp1t
local controlvars inct L.`assetvar' i.agewmax i.educ kids hhadult married unemp nilf 
*including L.hequity if controlling for home equity rather than home value

///1.  OLS Model no FE 
 reg consumpt L.`debtvar' `controlvars' if  L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  cluster(hhid0) robust
mat Table1[1,7]=_b[L.`debtvar']
mat Table1[2,7]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,7]=_b[inct]
mat Table1[4,7]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,7]=_b[L.`assetvar']
mat Table1[6,7]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,7]=e(N)
 reg expt L.`debtvar' `controlvars' if  L.`debtvar'>0 & tousend==1 & touse2==1 & touse3==1 & wave>=6 & wave<=17,  cluster(hhid0) robust
mat Table1[1,1]=_b[L.`debtvar']
mat Table1[2,1]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,1]=_b[inct]
mat Table1[4,1]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,1]=_b[L.`assetvar']
mat Table1[6,1]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,1]=e(N)
 reg durablet L.`debtvar' `controlvars' if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  cluster(hhid0) robust
mat Table1[1,4]=_b[L.`debtvar']
mat Table1[2,4]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,4]=_b[inct]
mat Table1[4,4]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,4]=_b[L.`assetvar']
mat Table1[6,4]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,4]=e(N)

matlist Table1

///2.  OLS Model with HH FE 
 xtreg consumpt `controlvars' L.`debtvar'  if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1  & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table1[1,8]=_b[L.`debtvar']
mat Table1[2,8]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,8]=_b[inct]
mat Table1[4,8]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,8]=_b[L.`assetvar']
mat Table1[6,8]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,8]=e(N)
 xtreg expt `controlvars' L.`debtvar' if  L.`debtvar'>0 & tousend==1 & touse2==1 & touse3==1 & wave>=6 & wave<=17,  fe cluster(hhid0) robust
mat Table1[1,2]=_b[L.`debtvar']
mat Table1[2,2]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,2]=_b[inct]
mat Table1[4,2]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,2]=_b[L.`assetvar']
mat Table1[6,2]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,2]=e(N)
 xtreg durablet `controlvars' L.`debtvar' if   L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table1[1,5]=_b[L.`debtvar']
mat Table1[2,5]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table1[3,5]=_b[inct]
mat Table1[4,5]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table1[5,5]=_b[L.`assetvar']
mat Table1[6,5]=(2 * ttail(e(df_r), abs(_b[L.`assetvar']/_se[L.`assetvar'])))
mat Table1[7,5]=e(N)
matlist Table1

///3. IV with postcode FE
drop Lhdebtt 
gen L`debtvar'=L.`debtvar'
local controlvars inct L`assetvar' i.agewmax i.educ kids hhadult married unemp nilf
*including Lhequity if controlling for home equity rather than home value

** Change panel variable from household to postcode
xtset, clear
xtset postcode
 xtivreg consumpt `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, fe first 
mat Table1[1,9]=_b[L`debtvar']
mat Table1[2,9]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table1[3,9]=_b[inct]
mat Table1[4,9]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat Table1[5,9]=_b[L`assetvar']
mat Table1[6,9]=(2 * ttail(e(df_rz), abs(_b[L`assetvar']/_se[L`assetvar'])))
mat Table1[7,9]=e(N)
 xtivreg expt `controlvars' (L`debtvar'  =  Lpostboom) if  L`debtvar'>0 &  tousend==1 & touse2==1 & touse3==1  & wave>=6 & wave<=17, fe  first
mat Table1[1,3]=_b[L`debtvar']
mat Table1[2,3]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table1[3,3]=_b[inct]
mat Table1[4,3]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat Table1[5,3]=_b[L`assetvar']
mat Table1[6,3]=(2 * ttail(e(df_rz), abs(_b[L`assetvar']/_se[L`assetvar'])))
mat Table1[7,3]=e(N)
 xtivreg durablet `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 &  touse==1 & touse2==1  & touse3==1 & wave>=6 & wave<=10, fe  first
mat Table1[1,6]=_b[L`debtvar']
mat Table1[2,6]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table1[3,6]=_b[inct]
mat Table1[4,6]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat Table1[5,6]=_b[L`assetvar']
mat Table1[6,6]=(2 * ttail(e(df_rz), abs(_b[L`assetvar']/_se[L`assetvar'])))
mat Table1[7,6]=e(N)

** Change panel variable back to household from postcode
xtset, clear
xtset hhid0 wave

/// show results for all models
matlist Table1 


*************
***TABLE 6***
*************
//accounting for imputed rent and adjusting for mortgage repayments
mat Table6 = J(7,2,.)
mat rown Table1 = Debtcoeff Debtpv Inccoeff Incpv Hpcoeff Hppv Obs
mat coln Table1 = TotalOLSFE TotalIV

//set up list of control variables for model hp1t
local controlvars inct L.hp1t i.agewmax i.educ kids hhadult married unemp nilf
//set up debt measure for model (hdebtt, hdebtinc, debtasset, mortinc)
local debtvar hdebtt

///1.  OLS Model with HH FE 
xtreg consumpadjt `controlvars' L.`debtvar' if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1  & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table6[1,1]=_b[L.`debtvar']
mat Table6[2,1]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table6[3,1]=_b[incadjt]
mat Table6[4,1]=(2 * ttail(e(df_r), abs(_b[incadjt]/_se[incadjt])))
mat Table6[5,1]=_b[L.hp1t]
mat Table6[6,1]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat Table6[7,1]=e(N)

///2. IV with postcode FE
drop Lhdebtt 
gen L`debtvar'=L.`debtvar'
local controlvars inct Lhp1t i.agewmax i.educ kids hhadult married unemp nilf

** Change panel variable from household to postcode
xtset, clear
xtset postcode
 xtivreg consumpadjt `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, fe first 
mat Table6[1,2]=_b[L`debtvar']
mat Table6[2,2]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table6[3,2]=_b[incadjt]
mat Table6[4,2]=(2 * ttail(e(df_rz), abs(_b[incadjt]/_se[incadjt])))
mat Table6[5,2]=_b[Lhp1t]
mat Table6[6,2]=(2 * ttail(e(df_rz), abs(_b[Lhp1t]/_se[Lhp1t])))
mat Table6[7,2]=e(N)

** Change panel variable back to household from postcode
xtset, clear
xtset hhid0 wave

/// show results for all models
matlist Table6
